package gov.va.vinci.dart.json.builder;

import java.text.SimpleDateFormat;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.biz.Activity;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.OperationalRequest;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.PreparatoryRequest;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.Role;
import gov.va.vinci.dart.json.ActivityView;

public class ActivityViewBuilder {
	public static final SimpleDateFormat SDF = new SimpleDateFormat("MM/dd/yyyy");

	public ActivityView build(final Activity activity, final Request request, final Person person) {
		ActivityView result = new ActivityView();
		
		if (activity == null || activity.getId() < 1) {
			// default values;
			result = new ActivityView();
			
			//TODO: PII look at this
//			result.setType(RequestController.RESEARCH_ACTIVITY);
			result.setType(Request.DATA_ACCESS);	//value used when creating the request
			
			return result;
		}
		
		result.setActivityId(activity.getId());
		
		result.setShortName(activity.getName());
		result.setOfficialName(activity.getOfficialName());
		result.setActivityStartDate(activity.getStartDate()==null?null:SDF.format(activity.getStartDate()));
		result.setActivityEndDate(activity.getEndDate()==null?null:SDF.format(activity.getEndDate()));
		result.setiRBExpirationDate(request.getIrbExpiration()==null?null:SDF.format(request.getIrbExpiration()));
		result.setiRBApprovalNumber(request.getIrbNumber());
		result.setTrackingNumber(request.getTrackingNumber());
		result.setRequestSubmittedDate(request.getSubmittedOn()==null?null:SDF.format(request.getSubmittedOn()));
		//result.setInitiatedDate(activity.getCreatedOn()==null?null:SDF.format(activity.getCreatedOn()));
		
		if (DartRequest.class.isAssignableFrom(request.getClass())) {
			result.setPrincipalInvestigator(((DartRequest)request).getPrincipalInvestigator());
			result.setType(Request.DATA_ACCESS);	
			
		} else if(OperationalRequest.class.isAssignableFrom( request.getClass() )) {
			result.setType(Request.OPERATIONS_DATA_ACCESS);
			
			result.setProgramOffice(((OperationalRequest)request).getProgramOffice());
			result.setJustification(((OperationalRequest)request).getJustification());
		}
		else if(PreparatoryRequest.class.isAssignableFrom( request.getClass() )) {
	        result.setPrincipalInvestigator(((PreparatoryRequest)request).getPrincipalInvestigator());
		    result.setType(Request.PREPARATORY_TO_RESEARCH_ACCESS);    
		    result.setExpectedIRBSubmissionDate(((PreparatoryRequest)request).
		            getExpectedIRBSubmissionDate()==null?null:SDF.format(((PreparatoryRequest)request).
		                    getExpectedIRBSubmissionDate()));
		}
		
		String createdBy;
		try {
			createdBy = Person.findByName(request.getCreatedBy()).getFullName();
		} catch (ValidationException e) {
			createdBy = request.getCreatedBy();
		} catch (ObjectNotFoundException e) {
			createdBy = request.getCreatedBy();
		}
		result.setRequestor(createdBy);

		//
		// superuser can view everything, but cannot edit
		if( person.hasRole(Role.SUPER_USER) ) {
			result.setEditable(false);
		} else {	//NOT a super-user
			
			try {
				result.setEditable( request.isEditable(null) );	//is the request editable for the requestor role (top-level request status)
			}
			catch (ObjectNotFoundException e) {
				;  // just squelch it
			}
		}//end else -- not a super-user
		
		return result;
	}
}
